@echo off
setlocal EnableDelayedExpansion

SET PATH_OPENOCD_EXE=.\\fw_image\\openocd-root\\openocd.exe
SET PATH_OPENOCD_TCL_BASE=.\\fw_image\\openocd-root\\tcl


echo .
echo ............................................................
echo Select [0-2] to program flash code, or 3 to exit
echo ............................................................
echo .
echo 0 - ATMx2xx-x1x
echo 1 - ATM33xx-5
echo 2 - ATM34xx-5
echo 3 - exit
echo .

SET APP_EXAMPLE=HCI_vendor

SET /P PLT_SEL=Type 0, 1, 2, 3 then press ENTER:
if %PLT_SEL%==0 goto ATMX2XX-X1X
if %PLT_SEL%==1 goto ATM33XX-5
if %PLT_SEL%==2 goto ATM34XX-5
if %PLT_SEL%==3 goto END

:ATMX2XX-X1X
SET CHIP_VER=ATMx2xx-x1x
SET PATH_OPENOCD_CFG=.\\fw_image\\%CHIP_VER%\\openocd\\atm2x_openocd.cfg
SET PATH_OPENOCD_TCL=.\\fw_image\\%CHIP_VER%\\openocd
echo .
echo ............................................................
echo Select [0-5] to program HCI_vendor flash code, or 6 to exit
echo ............................................................
echo .
echo 0 - ATMEVK_M2201
echo 1 - ATMEVK_M2202
echo 2 - ATMEVK_M2221
echo 3 - ATMEVK_M2231
echo 4 - ATMEVK_M2251
echo 5 - ATMEVK_M3201
echo 6 - ATMEVK_M3202
echo 7 - ATMEVK_M3221
echo 8 - ATMEVK_M3231
echo .

SET /P SEL=Type 0, 1, 2, 3, 4, 5, 6, 7, 8, 9 then press ENTER:
if %SEL%==0 (
        set BOARD=ATMEVK_M2201
        goto RUN
        )
if %SEL%==1 (
        set BOARD=ATMEVK_M2222
        goto BAREMETAL_RUN
        )
if %SEL%==2 (
        set BOARD=ATMEVK_M2221
        goto BAREMETAL_RUN
        )
if %SEL%==3 (
        set BOARD=ATMEVK_M2231
        goto BAREMETAL_RUN
        )
if %SEL%==4 (
        set BOARD=ATMEVK_M2251
        goto BAREMETAL_RUN
)
if %SEL%==5 (
        set BOARD=ATMEVK_M3201
        goto BAREMETAL_RUN
)
if %SEL%==6 (
        set BOARD=ATMEVK_M3202
        goto BAREMETAL_RUN
)
if %SEL%==7 (
        set BOARD=ATMEVK_M3221
        goto BAREMETAL_RUN
)
if %SEL%==8 (
        set BOARD=ATMEVK_M3231
        goto BAREMETAL_RUN
)
if %SEL%==9 goto END

:ATM33XX-5
SET CHIP_VER=ATM33xx-5
SET PATH_OPENOCD_CFG=.\\fw_image\\%CHIP_VER%\\openocd\\atmx3_openocd.cfg
SET PATH_OPENOCD_TCL=.\\fw_image\\%CHIP_VER%\\openocd
echo .
echo ............................................................
echo Select [0-5] to program HCI_vendor flash code, or 6 to exit
echo ............................................................
echo .
echo 0 - ATMEVK-3330-QN-6
echo 1 - ATMEVK-3330e-QN-6
echo 2 - ATMEVK-3330e-QN-7
echo 3 - ATMEVK-3325-CM-6
echo 4 - ATMEVK-3325-QK-6
echo 5 - ATMEVK-3325-LQK-6
echo .

SET /P SEL=Type 0, 1, 2, 3, 4, 5, 6 then press ENTER:
if %SEL%==0 (
        set BOARD=ATMEVK-3330-QN-6
        goto ZEPHYR_RUN
        )
if %SEL%==1 (
        set BOARD=ATMEVK-3330e-QN-6
        goto ZEPHYR_RUN
        )
if %SEL%==2 (
        set BOARD=ATMEVK-3330e-QN-7
        goto ZEPHYR_RUN
        )
if %SEL%==3 (
        set BOARD=ATMEVK-3325-CM-6
        goto ZEPHYR_RUN
        )
if %SEL%==4 (
        set BOARD=ATMEVK-3325-QK-6
        goto ZEPHYR_RUN
        )
if %SEL%==5 (
        set BOARD=ATMEVK-3325-LQK-6
        goto ZEPHYR_RUN
        )

if %SEL%==6 goto END

:ATM34XX-5
SET CHIP_VER=ATM34xx-5
SET PATH_OPENOCD_CFG=.\\fw_image\\%CHIP_VER%\\openocd\\atmx3_openocd.cfg
SET PATH_OPENOCD_TCL=.\\fw_image\\%CHIP_VER%\\openocd
echo .
echo ............................................................
echo Select [0-5] to program HCI_vendor flash code, or 6 to exit
echo ............................................................
echo .
echo 0 - ATMEVK-3405-PQK-5
echo 2 - ATMEVK-3430e-YQN-5
echo 3 - ATMEVK-3405-YBV-5
echo 4 - ATMEVK-3405-WQK-5
echo 5 - ATMEVK-3405-PBV-5
echo .


SET /P SEL=Type 0, 1, 2, 3, 4, 5 then press ENTER:
if %SEL%==0 (
        set BOARD=ATMEVK-3405-PQK-5
        goto ZEPHYR_RUN
        )
if %SEL%==1 (
        goto END
        )
if %SEL%==2 (
        set BOARD=ATMEVK-3430e-YQN-5
        goto ZEPHYR_RUN
        )
if %SEL%==3 (
        set BOARD=ATMEVK-3405-YBV-5
        goto ZEPHYR_RUN
        )
if %SEL%==4 (
        set BOARD=ATMEVK-3405-WQK-5
        goto ZEPHYR_RUN
        )
if %SEL%==5 (
        set BOARD=ATMEVK-3405-PBV-5
        goto ZEPHYR_RUN
        )
if %SEL%==6 goto END


:BAREMETAL_RUN
SET FTDI_BENIGN_BOOT=1
SET FTDI_HARD_RESET=1

SET OPENOCD_CMD=%PATH_OPENOCD_EXE% -s %PATH_OPENOCD_TCL_BASE% -s %PATH_OPENOCD_TCL% -f %PATH_OPENOCD_CFG% -c

%OPENOCD_CMD% "init; release_reset; sleep 100; set_normal_boot; exit"

SET FTDI_BENIGN_BOOT=
SET FTDI_HARD_RESET=

if "%CHIP_VER%"=="ATMx2xx-x1x" (
    SET FAST_LOAD=1
    SET ERASE_WHOLE=1
    SET PATH_FW=.\\fw_image\\%CHIP_VER%\\%APP_EXAMPLE%_%BOARD%.bin
    SET PATH_FLASH_NVDS=.\\fw_image\\%CHIP_VER%\\flash_nvds.bin
    SET PATH_FASTLOAD=.\\fw_image\\%CHIP_VER%\\openocd\\fast_load\\fast_load.bin
    @REM use {} for atm2x_load_ram_image and atm_fast_load tcl
    %OPENOCD_CMD% "init; sydney_erase_flash 0x04; atm2x_load_ram_image {!PATH_FASTLOAD!}; atm_fast_load {!PATH_FW!} 0x01 0x0; atm_fast_load {!PATH_FLASH_NVDS!} 0x01 0x78000; set _RESET_HARD_ON_EXIT 1; exit"
)

goto END

:ZEPHYR_RUN

SET OPENOCD_CMD=%PATH_OPENOCD_EXE% -s %PATH_OPENOCD_TCL_BASE% -s %PATH_OPENOCD_TCL% -f %PATH_OPENOCD_CFG% -c

if "%CHIP_VER%"=="ATM33xx-5" (
    SET FTDI_BENIGN_BOOT=1
    SET FTDI_HARD_RESET=1
    SET FAST_LOAD=1

    %OPENOCD_CMD% "init; release_reset; sleep 100; set_normal_boot; exit"

    SET FTDI_BENIGN_BOOT=
    SET FTDI_HARD_RESET=

    SET ATMSTK_BIN=.\\fw_image\\%CHIP_VER%\\atmwstk_CPD200.bin
    SET SPE_BIN=.\\fw_image\\%CHIP_VER%\\SPE_zephyr_%BOARD%.bin
    SET NS_BIN=.\\fw_image\\%CHIP_VER%\\%APP_EXAMPLE%_zephyr_%BOARD%.bin
    SET PATH_FASTLOAD=.\\fw_image\\%CHIP_VER%\\openocd\\fast_load\\fast_load.bin

    @REM just program NS since it's a ATM_NO_TZ build
    %OPENOCD_CMD% "init; atmx3_load_ram_image !PATH_FASTLOAD!; atm_fast_load 0xFFFFFFFF 0x02 0x10000; atm_fast_load 0xFFFFFFFF 0x02 0x200000; exit"
    %OPENOCD_CMD% "init; atmx3_load_ram_image !PATH_FASTLOAD!; atm_fast_load !NS_BIN! 0x05 0x10000; atm_fast_load !ATMSTK_BIN! 0x05 0x6e000; set _RESET_HARD_ON_EXIT 1; exit"
)

if "%CHIP_VER%"=="ATM34xx-5" (
    SET FTDI_BENIGN_BOOT=1
    SET FTDI_HARD_RESET=1
    set FAST_LOAD=1

    %OPENOCD_CMD% "init; release_reset; sleep 100; set_normal_boot; exit"

    SET FTDI_BENIGN_BOOT=
    SET FTDI_HARD_RESET=

    SET SPE_BIN=.\\fw_image\\%CHIP_VER%\\SPE_zephyr_%BOARD%.bin
    SET NS_BIN=.\\fw_image\\%CHIP_VER%\\%APP_EXAMPLE%_zephyr_%BOARD%.bin
    SET PATH_FASTLOAD=.\\fw_image\\%CHIP_VER%\\openocd\\fast_load\\fast_load.bin

    @REM just program NS since it's a ATM_NO_TZ build
    %OPENOCD_CMD% "init; atmx3_load_ram_image !PATH_FASTLOAD!; atm_fast_load 0xFFFFFFFF 0x02 0x10000; atm_fast_load 0xFFFFFFFF 0x02 0x200000; exit"
    %OPENOCD_CMD% "init; atmx3_load_ram_image !PATH_FASTLOAD!; atm_fast_load !NS_BIN! 0x05 0x10000; set _RESET_HARD_ON_EXIT 1; exit"
)

goto END


:END
echo exit
