from typing import TypeVar, Generic, Type
from packet.hci.hci_packet_implement import HciEvent, HciEventCommandComplete

T = TypeVar('T', bound=HciEventCommandComplete)

class HciEventCheckHelper(Generic[T]):
    def __init__(self, hci_event_type: Type[T]):
        self.event_type = hci_event_type

    def check_func(self, evt: HciEvent) -> bool:
        return isinstance(evt, self.event_type)
