#!/usr/bin/env python
"""
Byte-related helper utilities.
"""
from __future__ import annotations

from typing import Optional


def bytes_to_hex(data: Optional[bytes|bytearray]) -> str:
    """Convert bytes to hex string safely.

    - Returns "<None>" if data is None
    - Returns "<non-bytes>" if input is not bytes-like
    """
    if data is None:
        return "<None>"
    try:
        return data.hex(sep=" ")
    except Exception:
        return "<non-bytes>"

