#!/usr/bin/env python
'''
@file checksum.py

@brief Checksum utility

Copyright (C) Atmosic 2025
'''
from __future__ import annotations
from logging import getLogger
from lib.bytes_utils import bytes_to_hex

logger = getLogger(__name__)

def xor_bytes(data: bytearray) -> int:
    """Calculate XOR checksum for given data."""
    logger.debug(f"[xor_bytes] data: {bytes_to_hex(data)}")
    checksum = 0
    for byte in data:
        checksum ^= byte
    logger.debug(f"[xor_bytes] checksum: 0x{checksum:02X}")
    return checksum
