#!/usr/bin/env python
'''
@file io_base.py

@brief IO interface

Copyright (C) Atmosic 2024
'''

import abc


class IoBase(abc.ABC):

    @abc.abstractmethod
    def read(self, size: int, timeout: float):
        """Read data from the device (transport-agnostic).
        Returns bytes or None if no data/timeout.
        """
        raise NotImplementedError

    @abc.abstractmethod
    def write(self, data):
        """Write data to the device. Returns number of bytes written."""
        raise NotImplementedError

    @abc.abstractmethod
    def is_open(self) -> bool:
        """Check if device is open and ready for communication."""
        raise NotImplementedError

    @abc.abstractmethod
    def flush_input(self):
        """Flush input buffer (if applicable)."""
        raise NotImplementedError

    @abc.abstractmethod
    def flush_output(self):
        """Flush output buffer (if applicable)."""
        raise NotImplementedError
