#!/usr/bin/env python
'''
@file packet_factory_base.py

@brief Packet factory base class

Copyright (C) Atmosic 2025
'''
import abc
from typing import TypeVar
from packet.base.packet_data_base import PacketDataBase

T = TypeVar('T', bound=PacketDataBase)

class PacketFactoryBase(abc.ABC):
    @abc.abstractmethod
    def create_packet(self, data: bytes) -> PacketDataBase:
        """Create packet from raw bytes.
        
        Args:
            data: Raw packet bytes (already detected/sliced by detector)
            
        Returns:
            PacketDataBase: Created packet instance
        """
        pass
