from __future__ import annotations
from pydantic import BaseModel, Field

from Task.TaskOperation.xmodem_operation import UploadFirstAction
from pydantic_argparse.argparse_helper_funcs import ArgExtra
from Task.TaskOperation.xmodem_operation import XmodemOperation

class TaskXmodemContextBase(BaseModel):
    xmodem_serial: str = Field(
        description="Serial port for uart loader communication"
    )
    ram_image: str = Field(
        default="binfile/uart_loader.bin",
        description="Path to uart loader binary file"
    )
    xmodem_128: bool = ArgExtra(Field(
        default=False,
        description="Use XMODEM128 instead of XMODEM1k"
    ), engineer_mode=True)
    upload_first_action: UploadFirstAction = ArgExtra(Field(
        default=UploadFirstAction.ASK_VERSION,
        description="First action to perform after xmodem upload"
    ), engineer_mode=True)
    wait_time_before_upload_ms: int = ArgExtra(Field(
        default=200,
        description="Wait time before upload in milliseconds"
    ), engineer_mode=True)
    upload_timeout_ms: int = ArgExtra(Field(
        default=10000,
        description="Timeout for xmodem upload in milliseconds"
    ), engineer_mode=True)
    check_join_timeout_ms: int = ArgExtra(Field(
        default=11,
        description="Timeout for join check in milliseconds"
    ), engineer_mode=True)

    def to_xmodem_init_context(self) -> XmodemOperation.InitContext:
        return XmodemOperation.InitContext(
            xmodem_serial=self.xmodem_serial,
            ram_image=self.ram_image,
            xmodem_128=self.xmodem_128,
            upload_first_action=self.upload_first_action,
            wait_time_before_upload_ms=self.wait_time_before_upload_ms,
            upload_timeout_ms=self.upload_timeout_ms,
            check_join_timeout_ms=self.check_join_timeout_ms
        )
