#!/usr/bin/env python
from __future__ import annotations
from logging import getLogger

from atm_file_parser.atm_file_parser import AtmFileParser
from lib.mutil_pydantic_inherit_base import (
    MultiPydanticInheritBase, Field
)

logger = getLogger(__name__)

class TaskExportAtmFilesContext(MultiPydanticInheritBase):
    atm_path: str = Field(
        description="Path to .atm file to export"
    )
    export_dir: str = Field(
        description="Export directory for extracted files"
    )

class TaskExportAtmFiles:
    def __init__(self,ctx: TaskExportAtmFilesContext):
        """Initialize TaskShowAtm"""
        self.ctx = ctx

    def run(self):
        """Main execution function for TaskShowAtm task"""
        logger.info(f"=== TaskShowAtm Task Started ===")
        atm = AtmFileParser(self.ctx.atm_path)
        atm.export_binaries(self.ctx.export_dir)
