# Error Code Reference

This document provides a complete reference for all error codes used by the UART Loader Host application.

## Error Code System

### Format: VMMIII
- **V**: Version (1 digit) - Error code schema version (currently 1)
- **MM**: Major (2 digits) - Major error category (01-99)
- **III**: Minor (3 digits) - Specific error within category (001-999)

### Examples
- `101001`: Version=1, Major=01, Minor=001 → HCI Status Error: Invalid parameter
- `102001`: Version=1, Major=02, Minor=001 → Serial I/O Error: Port open failed
- `107001`: Version=1, Major=07, Minor=001 → Programming Agent Error: Boot event timeout

## Exit Codes

| Code | Description |
|------|-------------|
| 0 | Success - Operation completed successfully |
| 999999 | Maximum expected error code |
| 1000000 | Unexpected/unknown error |
| 1000001 | Keyboard interrupt (Ctrl+C) |

## Major Error Categories

| Major Code | Category | Description | Error Range |
|------------|----------|-------------|-------------|
| 01 | HCI Status Error | Device-reported HCI status errors | 101001-101999 |
| 02 | Serial I/O Entry Error | Serial port communication errors | 102001-102999 |
| 03 | Device I/O Module Error | Device I/O module operation errors | 103001-103999 |
| 04 | Packet Module Error | Packet handling errors | 104001-104999 |
| 05 | HCI Module Error | HCI module operation errors | 105001-105999 |
| 06 | HCI Gateway Error | HCI gateway communication errors | 106001-106999 |
| 07 | Programming Agent Error | Programming agent operation errors | 107001-107999 |
| 08 | HCI Command Operation Error | HCI command execution errors | 108001-108999 |
| 09 | Xmodem Operation Error | Xmodem protocol errors | 109001-109999 |

## Detailed Error Codes

### HCI Status Errors (101xxx)
Device-reported errors from HCI status responses.

| Code | Description |
|------|-------------|
| 101001 | Invalid parameter |
| 101002 | XOR checksum verification failed |
| 101003 | Send data failed |
| 101004 | Insufficient memory |
| 101005 | XOR verification mismatch |
| 101006 | SHA256 verification mismatch |
| 101007 | Operation timeout |
| 101008 | System busy |
| 101009 | Unsupported block size |
| 101010 | Memory access error |
| 101011 | Protocol version error |
| 101012 | Baudrate invalid |

### Serial I/O Entry Errors (102xxx)
Serial port communication errors.

| Code | Description |
|------|-------------|
| 102001 | Port open failed |
| 102002 | Read operation failed |
| 102003 | Write operation failed |

### Device I/O Module Errors (103xxx)
Device I/O module operation errors.

| Code | Description |
|------|-------------|
| 103001 | Read argument error |
| 103002 | Read immediate no data |
| 103003 | Read timeout |

### Packet Module Errors (104xxx)
Packet handling errors.

| Code | Description |
|------|-------------|
| 104001 | Read until timeout |
| 104002 | Write not entirely |

### HCI Module Errors (105xxx)
HCI module operation errors.

| Code | Description |
|------|-------------|
| 105001 | Read packet type mismatch |

### HCI Gateway Errors (106xxx)
HCI gateway communication errors.

| Code | Description |
|------|-------------|
| 106001 | Event format error |

### Programming Agent Errors (107xxx)
Programming agent operation errors.

| Code | Description |
|------|-------------|
| 107001 | Boot event timeout |
| 107002 | Invalid programming write data argument |
| 107003 | Unexpected sequence ID |
| 107004 | RAM XOR checksum mismatch |
| 107005 | Storage XOR checksum mismatch |
| 107006 | Dump operation timeout |
| 107007 | Dump XOR checksum mismatch |

### HCI Command Operation Errors (108xxx)
HCI command execution errors.

| Code | Description |
|------|-------------|
| 108001 | HCI command failed |
| 108002 | Dump SHA256 checksum mismatch |
| 108003 | Programming SHA256 checksum mismatch |
| 108004 | Erase size is smaller than binary size |

### Xmodem Operation Errors (109xxx)
Xmodem protocol errors.

| Code | Description |
|------|-------------|
| 109001 | Xmodem upload timeout |
| 109002 | Xmodem upload failed |
| 109003 | Xmodem getc timeout |
| 109004 | Xmodem version request timeout |

## Unexpected Error Codes (1000000+)
Error codes 1000000 and above indicate unexpected or internal system errors.

| Code | Description |
|------|-------------|
| 1000000 | Unexpected/unknown error - Internal system error occurred |
| 1000001+ | Internal error codes - Contact support for assistance |

**Note:** If you encounter error codes 1000000 or higher, this indicates an unexpected system condition. Please check the detail log file for more information and contact technical support if the issue persists.

## Getting More Information

When an error occurs:
1. Note the **complete error code** (VMMIII format)
2. Check the **detail log file** in `logs/tool/YYYYMMDD_HHMMSS_<command>/tool_detail.log`
3. Look for additional context around the error in the log file
4. Use this reference to understand the specific error meaning

For more information about logging and debugging, see the main [README.md](README.md).