from pydantic import BaseModel
import logging
from .handler.serial_handler import SerialHandler
from .handler.telnet_handler import TelnetHandler

class UartLoggerContext(BaseModel):
    raw_debug_serial: str = ""
    raw_debug_baudrate: int = 115200
    raw_debug_tcp_port: int = 0
    packet_debug_serial: str = ""
    packet_debug_baudrate: int = 115200

def setup_uart_logger(ctx: UartLoggerContext):
    uart = logging.getLogger("uart")
    # file_handler = logging.FileHandler("uart.log")
    # file_handler.setFormatter(logging.Formatter("%(message)s"))
    # uart.addHandler(file_handler)
    if ctx.raw_debug_serial:
        handler = SerialHandler(ctx.raw_debug_serial,
                                ctx.raw_debug_baudrate)
        uart.addHandler(handler)
    if ctx.raw_debug_tcp_port:
        handler = TelnetHandler(port = ctx.raw_debug_tcp_port)
        uart.addHandler(handler)
    packet = logging.getLogger("packet")
    if ctx.packet_debug_serial:
        handler = SerialHandler(ctx.packet_debug_serial,
                                ctx.packet_debug_baudrate)
        packet.addHandler(handler)