#!/usr/bin/env python
'''
@file hci_event_detector.py

@brief HCI event detector implementation

Copyright (C) Atmosic 2025
'''
from deviceio.device_io_read_detector_base import DeviceIoReadDetectorBase

class HciEventDetector(DeviceIoReadDetectorBase):
    def detect_drop_size(self, buffer: bytearray) -> int:
        drop_size = 0
        for i in range(len(buffer)-1):
            if buffer[i] == 0x04 and \
                (buffer[i+1] == 0x0e or buffer[i+1] == 0xff):
                break
            drop_size += 1
        return drop_size

    def detect_read_size(self, buffer: bytearray) -> int:
        if len(buffer) < 3:
            return 0
        if buffer[0] != 0x04:
            return 0
        plen = buffer[2]
        return plen + 3
