from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field
from csv_report.csv_report_helper import csv_report_file
from csv_report.csv_report_auto_calculate import CsvReportAutoCalculate

@csv_report_file("program_full_spend_time")
class ProgramFullSpendTimeReport(BaseModel, CsvReportAutoCalculate):
    """Device information report model."""
    timestamp: datetime = Field(default_factory=datetime.now)
    cmd_start_timestamp: Optional[datetime] = None
    serial: Optional[str] = None
    xmodem_ram_file: Optional[str] = None
    xmodem_ram_size: Optional[int] = None
    xmodem_init_ms: Optional[int] = None
    xmodem_upload_ms: Optional[int] = None
    uart_loader_file: Optional[str] = None
    uart_loader_bin_size: Optional[int] = None
    wait_uart_loader_boot_event_time_ms: Optional[float] = None
    uart_loader_init_ms: Optional[int] = None
    full_programming_time_ms: Optional[int] = None
    full_verification_time_ms: Optional[int] = None

    def update_before_save(self) -> None:
        pass