from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field
from csv_report.csv_report_helper import csv_report_file
from csv_report.csv_report_auto_calculate import CsvReportAutoCalculate

@csv_report_file("program_one_bin")
class UartLoaderSpendTimeReport(BaseModel, CsvReportAutoCalculate):
    """Device information report model."""
    timestamp: datetime = Field(default_factory=datetime.now)
    cmd_start_timestamp: Optional[datetime] = None
    serial: Optional[str] = None
    file: Optional[str] = None
    size: Optional[int] = None
    programming_time_ms: Optional[float] = None
    programming_speed_kBps: Optional[float] = None
    verification_time_ms: Optional[float] = None

    def update_before_save(self) -> None:
        if self.size is None or self.programming_time_ms is None:
            return
        if self.programming_time_ms > 0:
            self.programming_speed_kBps = self.size / self.programming_time_ms
