#!/usr/bin/env python
from __future__ import annotations
from logging import getLogger

from atm_file_parser.atm_file_parser import AtmFileParser
from lib.mutil_pydantic_inherit_base import (
    MultiPydanticInheritBase, Field
)

logger = getLogger(__name__)

class TaskAtmAppendFlashBinContext(MultiPydanticInheritBase):
    input_atm_path: str = Field(
        description="Path to input .atm file"
    )
    output_atm_path: str = Field(
        description="Path to output .atm file"
    )
    bin_path: str = Field(
        description="Path to binary file to append"
    )
    address: int = Field(
        description="Address of binary file to append"
    )
    erasing_region_size: int = Field(
        description="Region size of binary file to append (for erasing)"
    )
    extra_info: str = Field(
        description="Extra info for appended command"
    )

class TaskAtmAppendFlashBin:
    
    def __init__(self,ctx: TaskAtmAppendFlashBinContext):
        """Initialize TaskAtmAppendBin"""
        self.ctx = ctx

    def run(self) -> None:
        """Main execution function for TaskAtmAppendBin task"""
        logger.info(f"=== TaskAtmAppendBin Task Started ===")
        atm = AtmFileParser(self.ctx.input_atm_path)
        atm.append_flash(self.ctx.bin_path, self.ctx.address,
                         self.ctx.erasing_region_size, self.ctx.extra_info)
        atm.save(self.ctx.output_atm_path)
        logger.info("=== TaskAtmAppendBin Task Completed ===")
