#!/usr/bin/env python3
"""
Main entry point for UART loader host Tool
Automatically sets up PYTHONPATH and runs the tool
"""

import sys
from pathlib import Path

def setup_pythonpath():
    """Add Model directory to Python path"""
    script_dir = Path(__file__).parent
    model_dir = script_dir / "Model"
    
    if model_dir.exists():
        model_path = str(model_dir)
        if model_path not in sys.path:
            sys.path.insert(0, model_path)

def main():
    """Main launcher function"""
    # Setup Python path first
    setup_pythonpath()
    # Import and run the UART loader host tool
    from common_launcher import launch_app
    launch_app()


if __name__ == "__main__":
    main()
