#!/usr/bin/env python
'''
@file device_io_read_detector_base.py

@brief Device IO read detector base class

Copyright (C) Atmosic 2025
'''
import abc

class DeviceIoReadDetectorBase(abc.ABC):
    @abc.abstractmethod
    def detect_drop_size(self, buffer: bytearray) -> int:
        pass
    @abc.abstractmethod
    def detect_read_size(self, buffer: bytearray) -> int:
        pass
