from __future__ import annotations
from pydantic import BaseModel, Field

from Task.TaskOperation.reset_operation import (
    ResetOperation, UartLoaderBootSource
)
from pydantic_argparse.argparse_helper_funcs import ArgExtra

class TaskResetSupportContextBase(BaseModel):
    reset_support:str = ArgExtra(Field(
        default="none",
        description="Reset support implementation (jlinkob, rts)"
    ), engineer_mode=True)
    uart_loader_mode: UartLoaderBootSource = ArgExtra(Field(
        default=UartLoaderBootSource.RAM,
        description="Uart loader mode (ram, rram)"
    ), engineer_mode=True)
    jlink_sn: str = ArgExtra(Field(
        default="",
        description="J-Link serial number (for jlinkob reset support)"
    ), engineer_mode=True)
    reset_serial: str = ArgExtra(Field(
        default="",
        description="Serial port for RTS reset support"
    ), engineer_mode=True)

    def to_reset_operation_init_context(self) -> ResetOperation.InitContext:
        return ResetOperation.InitContext(
            reset_support=self.reset_support,
            uart_loader_mode=self.uart_loader_mode,
            jlink_sn=self.jlink_sn,
            reset_serial=self.reset_serial
        )
