#!/usr/bin/env python
from __future__ import annotations
from logging import getLogger

from atm_file_parser.atm_file_parser import AtmFileParser
from lib.mutil_pydantic_inherit_base import (
    MultiPydanticInheritBase, Field
)

logger = getLogger(__name__)

class TaskAtmAppendRramBinContext(MultiPydanticInheritBase):
    input_atm_path: str = Field(
        description="Path to input .atm file"
    )
    output_atm_path: str = Field(
        description="Path to output .atm file"
    )
    bin_path: str = Field(
        description="Path to binary file to append"
    )
    address: int = Field(
        description="Address of binary file to append"
    )
    extra_info: str = Field(
        description="Extra info for appended command"
    )

class TaskAtmAppendRramBin:
    def __init__(self,ctx: TaskAtmAppendRramBinContext):
        """Initialize TaskAtmAppendBin"""
        self.ctx = ctx

    def run(self) -> None:
        """Main execution function for TaskAtmAppendBin task"""
        logger.info(f"=== TaskAtmAppendBin Task Started ===")
        atm = AtmFileParser(self.ctx.input_atm_path)
        atm.append_rram(self.ctx.bin_path, self.ctx.address,
                        self.ctx.extra_info)
        atm.save(self.ctx.output_atm_path)
