#!/usr/bin/env python
from __future__ import annotations
from logging import getLogger

from atm_file_parser.atm_file_parser import AtmFileParser
from lib.mutil_pydantic_inherit_base import (
    MultiPydanticInheritBase, Field
)

logger = getLogger(__name__)

class TaskAtmShowContext(MultiPydanticInheritBase):
    atm_path: str = Field(
        description="Path to .atm file to show"
    )

class TaskAtmShow:
    def __init__(self,ctx: TaskAtmShowContext):
        """Initialize TaskShowAtm"""
        self.ctx = ctx

    def run(self) -> None:
        """Main execution function for TaskShowAtm task"""
        logger.info(f"=== TaskShowAtm Task Started ===")
        atm = AtmFileParser(self.ctx.atm_path)
        infos = atm.get_all_info()
        for info in infos:
            logger.info(info)
