#!/usr/bin/env python
'''
@file byte_stream_observer.py

@brief Observer interface/base for receiving raw byte stream chunks.
       Includes an enable/disable switch so observers can pause receipt.

Copyright (C) Atmosic 2024
'''
from __future__ import annotations

class ByteStreamObserver:
    """Observer for raw bytes.

    Subclasses should override on_bytes(). The default implementation
    provides pause()/resume() and is_receiving() so observers can control
    whether they currently accept notifications.
    """

    def __init__(self) -> None:
        self._receiving = True

    def on_bytes(self, data: bytes) -> None:  # pragma: no cover (interface)
        raise NotImplementedError

    # Control receiving state
    def pause(self) -> None:
        self._receiving = False

    def resume(self) -> None:
        self._receiving = True

    def is_receiving(self) -> bool:
        return self._receiving

