from typing import TypeVar, Generic, Type
from packet.hci_module import HciModule
from packet.hci.hci_packet_implement import HciEvent, HciEventCommandComplete
from .hci_event_check_helper import HciEventCheckHelper

T = TypeVar('T', bound=HciEventCommandComplete)

class HciEventWaitHelper(Generic[T]):
    def __init__(self, hci_module: HciModule, hci_event_type: Type[T],
                 timeout_s: float):
        self.hci_module = hci_module
        self.event_type = hci_event_type
        self.timeout_s = timeout_s
        self.check_helper = HciEventCheckHelper(hci_event_type)

    def wait_func(self, evt: HciEvent) -> T:
        
        evt = self.hci_module.read_until(self.check_helper.check_func,
                                         timeout_s=self.timeout_s)
        assert isinstance(evt, self.event_type)
        return evt
