#!/usr/bin/env python
"""
@file reset_support_base.py

@brief Base interface for device reset support

Copyright (C) Atmosic 2025
"""
from __future__ import annotations
from abc import ABC, abstractmethod

class ResetSupportBase(ABC):
    """Base interface for device reset operations"""
    
    @abstractmethod
    def reset_normal_boot(self, timeout_ms: int = 5000) -> None:
        """Reset device to normal boot mode

        Args:
            timeout_ms: Timeout in milliseconds for reset operation
        """
        pass

    @abstractmethod
    def reset_bboot_mode(self, timeout_ms: int = 5000) -> None:
        """Reset device to bootloader mode

        Args:
            timeout_ms: Timeout in milliseconds for res
        """
        pass

    def get_name(self) -> str:
        """Get the name of this reset support implementation

        Returns:
            Human-readable name of the reset support
        """
        return self.__class__.__name__

    def module_stop(self) -> None:
        pass
