from __future__ import annotations
from pydantic import Field

from pydantic_argparse.argparse_helper_funcs import ArgExtra
from Task.TaskContextBase.task_uart_loader_context_base import (
    TaskUartLoaderContextBase, TaskFuncChangeBaudrateContextBase
)
from Task.TaskOperation.uart_loader_operation import UartLoaderOperation


class TaskProgramContextBase(TaskUartLoaderContextBase,
                             TaskFuncChangeBaudrateContextBase):
    check_ram_xor: bool = ArgExtra(Field(
        default=False,
        description="Enable RAM block XOR verification"
    ), engineer_mode=True)
    check_rram_xor: bool = ArgExtra(Field(
        default=False,
        description="Enable RRAM block XOR verification"
    ), engineer_mode=True)
    skip_check_sha256: bool = Field(
        default=False,
        description="Disable SHA256 verification"
    )
    skip_send_ff_packets: bool = ArgExtra(Field(
        default=True,
        description="Skip send all 0xFF packets"
    ), engineer_mode=True)
    count_group_packets: int = ArgExtra(Field(
        default=16,
        description="Count of group packets"
    ), engineer_mode=True)
    group_index_check_rsp: int = ArgExtra(Field(
        default=15,
        description="Group index for response checking"
    ), engineer_mode=True)
    erase_timeout: float = Field(
        default=10.0,
        description="Timeout for erase operation"
    )
    
    def to_program_binary_context_base(self, target_address: int) \
        -> UartLoaderOperation.ProgramBinaryContextBase:
        return UartLoaderOperation.ProgramBinaryContextBase(
            target_address=target_address,
            check_ram_xor=self.check_ram_xor,
            check_rram_xor=self.check_rram_xor,
            check_program_sha256= not self.skip_check_sha256,
            count_group_packets=self.count_group_packets,
            group_index_check_rsp=self.group_index_check_rsp,
            skip_send_ff_packets=self.skip_send_ff_packets,
        )
