#!/usr/bin/env python
from __future__ import annotations
from logging import getLogger

from atm_file_parser.atm_file_parser import AtmFileParser
from lib.mutil_pydantic_inherit_base import (
    MultiPydanticInheritBase, Field
)

logger = getLogger(__name__)

class TaskAtmAppendFlashEraseContext(MultiPydanticInheritBase):
    input_atm_path: str = Field(
        description="Path to input .atm file"
    )
    output_atm_path: str = Field(
        description="Path to output .atm file"
    )
    address: int = Field(
        description="Address of binary file to append"
    )
    size: int = Field(
        description="Region size of binary file to append (for erasing)"
    )

class TaskAtmAppendFlashErase:
    
    def __init__(self,ctx: TaskAtmAppendFlashEraseContext):
        """Initialize TaskAtmAppendBin"""
        self.ctx = ctx

    def run(self) -> None:
        """Main execution function for TaskAtmAppendBin task"""
        logger.info(f"=== TaskAtmAppendBin Task Started ===")
        atm = AtmFileParser(self.ctx.input_atm_path)
        atm.append_erase_flash(self.ctx.address, self.ctx.size)
        atm.save(self.ctx.output_atm_path)
        logger.info("=== TaskAtmAppendBin Task Completed ===")
